<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 */
class Pf_Base_Post_Shortcode extends Pf_Plugin_Shortcode_Controller
{

    protected $select_columns;
    protected $base_select;
    protected $content;
    protected $conditions = '';
    protected $param = array();

    public function __construct($attrs = array(), $content = '')
    {
        parent::__construct();
        $this->view->set_path('/admin/plugins/post/public/views');
        $this->model = new Pf_Post_Post_Model;
        $this->attrs = !empty($attrs) ? $attrs : array();
        $this->setting->set_name('pf_post');
        $this->content = $content;
        $this->base_select(null, true);
        $this->select_columns($this->get_attr('select'));
        $this->conditions = ' WHERE post_status = 1 and (post_published_date <= "' . get_current_date() . '" or day(post_published_date) = 0) and '
                . '(post_unpublished_date > "' . get_current_date() . '" or (post_unpublished_date) = 0) ';
    }

    /**
     * Columns select from table
     * @param array $columns
     */
    protected function select_columns($columns = '')
    {
        if (!empty($columns)) {
            $columns = is_array($columns) ? $columns : func_get_args();
        }
        if (empty($columns) || count($columns) === 0) {
            $columns = array(
                'post_title',
                'post_author',
                'post_category',
                'post_created_date',
                'post_published_date',
                'post_content',
                'post_thumbnail',
                'post_views',
                'category_name',
                'user_displayname',
                'user_avatar',
                'user_name'
            );
        }
        array_unshift($columns, 'pf_posts.id');
        $this->select_columns = $columns;
    }

    /**
     * Base select builder
     * @param object $select
     */
    protected function base_select($select = null, $no_category = false)
    {
        $this->base_select = null;
        if (!is_null($select)) {
            $this->base_select = $select;
        } else {
            $join_type = $no_category ? 'LEFT JOIN' : 'INNER JOIN';
            $this->base_select = $this->model->table('pf_posts')
                    ->join('pf_categories', 'pf_posts.post_category = pf_categories.id', $join_type)
                    ->left_join('pf_users', 'pf_posts.post_author = pf_users.id');
        }
    }

    /**
     * Get data to build conditions
     */
    protected function get_value_attr_base()
    {
        $base = array(
            'id' => 'pf_posts.id',
            'author' => 'post_author',
            'category' => 'post_category',
            'tag' => 'post_tag_tag_id'
        );

        if ($this->get_attr('tag')) {
            $this->base_select->join('pf_post_tags', 'pf_posts.id = pf_post_tags.post_tag_post_id');
        }

        foreach ($base as $key => $value) {
            $data = $this->generate_conditons($key, $value);
            $filter = isset($data[1]) ? array_filter($data[1]) : array();
            if (isset($data[1]) && !empty($filter)) {
                $this->conditions .= " and ({$data[0]}) ";
                $this->param = array_merge($this->param, $data[1]);
            }
        }
    }

    protected function get_order_attr()
    {
        if ($this->get_attr('order_field') && $this->get_attr('order_type')) {
            $field = $this->get_value_attr('order_field');
            $type = $this->get_value_attr('order_type');
            if (count($type) > 0 && count($field) > 0) {
                $order_fields = array(
                    'id' => 'pf_posts.id',
                    'date' => 'post_published_date',
                    'title' => 'post_title',
                    'views' => 'post_views'
                );
                $type = in_array($type[0], array('desc', 'asc')) ? $type[0] : 'post_published_date asc';
                $field = in_array($field[0], array_keys($order_fields)) ? $order_fields[$field[0]] : 'pf_posts.id';
                $this->conditions .= " order by {$field} {$type} ";
            } else {
                $this->conditions .= ' order by post_created_date asc ';
            }
        } else {
            $this->conditions .= ($this->setting->get_value('ordering') == 1) ? ' order by post_created_date desc ' : '';
        }
    }

    protected function get_pagination_attr()
    {
        $result = array();
        $number_items = NUM_PER_PAGE;
        if ($this->get_attr('pagination') === 'true') {
            if ($this->get_attr('number_items')) {
                $number_items = (int) $this->get_attr('number_items');
            }
            $total = $this->base_select->conditions($this->conditions)
                            ->param($this->param)->counts('pf_posts');
            $pages = isset($this->attrs['page']) ? $this->get_by_pattern($this->attrs['page']) : 1;
            if ($total < 0 || empty($pages)) {
                return;
            }
            $page = isset($pages[1]) && (int) $pages[1] > 0 ? $pages[1] : 1;
            $per_page = (int) ($page - 1) * $number_items;
            $this->conditions .= "LIMIT {$per_page},{$number_items}";
            $paging = new Pf_Paginator($total, $number_items, $pages[0]);
            $url = public_url($this->build_url(), true) . (substr((public_url($this->build_url(), true)), -1) !== '/' ? '/' : '');
            $result = array('total' => $total, 'link' => $paging->page_links($url, '', true));
        } elseif ($this->get_attr('number_items')) {
            $number_items = (int) $this->get_attr('number_items');
            $this->conditions .= "LIMIT $number_items";
        }
        return $result;
    }

    /**
     * Get content of shortcode
     * @param array $data
     * @return string
     */
    protected function get_content($data, $page = 'post_lists')
    {
        if(empty($this->content)){
            $theme_actived = strtolower(get_option('active_theme'));
            $all_theme = array();
            if(file_exists($path = ABSPATH . '/themes/' . $theme_actived . '/post_templates.php')){
                $all_theme = require_once $path;
            }
            if ($page == 'post_lists') {
                // Lấy giao diện về
                $theme_name = in_array(strtolower($this->get_attr('theme')), array('default', 'timeline', 'full-width', 'multiple-columns')) ? strtolower($this->get_attr('theme')) : 'default';

                // Kiểm tra xem ở vị trí nào
                $theme_position = $this->get_attr('theme_position');
                $theme_position = !empty($theme_position) ? $theme_position : 'left';

                // Nếu là multicolumn thì có bao nhiêu cột
                $theme_column_size = $this->get_attr('theme_columns');
                if(!empty($theme_column_size) && (int)$theme_column_size !=0 && 12%(int)$theme_column_size == 0){
                    $theme_column_size = 12 / (int) $theme_column_size;
                }else{
                    $theme_column_size = 4;
                }

                $tmp = isset($all_theme['post_lists']) ? $all_theme['post_lists']  : '';
                if($theme_name == 'timeline'){
                    $this->content = isset($tmp['timeline'][$theme_position]) ? $tmp['timeline'][$theme_position] : '';
                }else{
                    $this->content = isset($tmp[$theme_name]) ? $tmp[$theme_name] : '';
                }
            }else{
                $this->content = isset($all_theme['post_detail']['default']) ? $all_theme['post_detail']['default'] : '';
            }
        }
        $post_data = is_array($data) ? array_filter($data) : $data;
        if (!isset($post_data['data']) || empty($post_data['data'])) {
            $have = $this->remove_tag('have_post');
            $no_post = $this->get_tag('no_post');
            if (isset($no_post[1])) {
                return $have ? str_replace($no_post[0], $no_post[1], $this->content) : $no_post[1];
            } else {
                return '<p>' . __('No post', 'pf_post') . '</p>';
            }
        }
        $transforms = array_map('transformer_post', $post_data['data']);

        $this->remove_tag('no_post');
        $have_post = $this->get_tag('have_post');
        $replace = isset($have_post[1]) ? $have_post[1] : $this->content;
        $posts = '';
        $parity = false;
        if (isset($theme_name) && isset($theme_position) && $theme_name == 'timeline' && $theme_position == 'mid') {
            $parity = true;
        }
        $i = 0;
        foreach ($transforms as $item) {
            $item['parity'] = $parity == true && $i % 2 == 0 ? 'pull-left' : 'pull-right';
            $posts .= $this->replace_tag($item, $replace);
            $i++;
        }

        if (isset($have_post[1])) {
            $posts = str_replace($have_post[0], $posts, $this->content);
        }

        if (isset($theme_name) && $theme_name == 'multiple-columns') {
            $posts = str_replace('{theme_column_size}', "col-md-{$theme_column_size}", $posts);
        }

        if (isset($data['link'])) {
            $posts = $this->get_attr('pagination_position') == 'top' ? $data['link'] . $posts : $posts . $data['link'];
        }
        return $posts;
    }

    /**
     * Build URL shortcode post
     * @return string
     */
    protected function build_url()
    {
        $params = array('id', 'category', 'author', 'order_field', 'order_type', 'tag', 'title');
        $attrs = $this->attrs;
        $url = array();
        foreach ($attrs as $key => $value) {
            $get_value = $this->get_by_pattern($value);
            $tmp = is_array($get_value) ? array_filter($get_value) : $get_value;
            if (in_array($key, $params) && count($tmp) === 2) {
                $url[] = "{$tmp[0]}:{$tmp[1]}";
            }
        }
        return is_array($url) ? implode('/', $url) : '';
    }

    /**
     * Count all comment by post
     * @param array $post_id
     * @return type
     */
    protected function get_comments($post_id)
    {
        $data = is_array($post_id) ? array_map('generate_param_count_comment', $post_id) : array('key_' . $post_id);
        $comment = $this->model->table('pf_comments')->select('count(id) as counted, comment_key')->set_joins(array())
                        ->conditions('Where comment_key in(' . generate_where_in($data) . ') and comment_status = 1 group by comment_key')
                        ->param($data)->get();
        $result = array();
        foreach ($post_id as $item) {
            $result[$item] = find_comment_item($item, $comment);
        }
        return $result;
    }

    /**
     * Get all tag of post
     * @param array $post_id
     * @param string $url
     * @return array
     */
    protected function get_tag_post($post_id, $url)
    {
        $tmp = is_array($post_id) ? $post_id : array($post_id);
        $tags = $this->model->table('pf_post_tags')->select('post_tag_post_id, post_tag_tag_id')->set_joins(array())
                        ->conditions("Where post_tag_post_id in(" . generate_where_in($tmp) . ")")->param($tmp)->get();
        $tags_select = array_unique(array_map('get_tag_post_select', $tags));

        if (count($tags_select) == 0) {
            return array();
        }
        $tags_name = $this->model->table('pf_tags')->select('id, tag_name')
                        ->conditions('Where id in(' . generate_where_in($tags_select) . ')')
                        ->param($tags_select)->get();

        $result = array();
        foreach ($tags as $tag) {
            if (in_array($tag->post_tag_post_id, $post_id)) {
                $result[$tag->post_tag_post_id][] = find_tag_item($tag->post_tag_tag_id, $url, $tags_name);
            }
        }
        return $result;
    }

}
